viewer.mode=OVERLAY

function setup()
    print("reorder tabs to see different versions")
    tab1={3,9,27,81}
    parameter.action("next",nxt)    
    colr={color(255,0,0),color(0,255,0),
    color(0,255,255),color(255,255,0)}
    assert(OrbitViewer, "Please include Cameras as a dependency")
    scene = craft.scene() 
    v=scene.camera:add(OrbitViewer,vec3(50,50,50), 8, 0, 1000)
    v.rx=30
    v.ry=30
    count=-1
    
    
    scene.voxels.blocks:addAssetPack("Blocks")
    tab = scene.voxels.blocks:new("Table")
    tab.setTexture(ALL, "Blocks:Table")
    
    scene.voxels:fill("Table")    
    scene.voxels.visibleRadius=200
    scene.voxels:resize(vec3(60,1,60))          
    scene.voxels.coordinates = vec3(50,50,50) 
    entity = scene:entity()
    volume = entity:add(craft.volume, 300, 300, 300)
    
    ss=3
    val=1
    randomColor = color(math.random(255),math.random(255),math.random(255))
    cube(0,0,0,3)  

end

function update(dt)
    scene:update(dt)
end

function draw()
    update(DeltaTime)
    scene:draw()  
end

function nxt()   
    clr=true
    cube(0,0,0,ss)
    val=val+1
    if val>4 then
        val=1
        v.zoom=3
    end
    ss=tab1[val]
    clr=false
    randomColor = color(math.random(255),math.random(255),math.random(255))
    cube(0,0,0,ss)
    v.zoom=v.zoom*2.8
end

function cube(x,y,z,size)
    local s=size//3
    for x1=-s,s,s do
        for y1=-s,s,s do
            for z1=-s,s,s do
                if (y1~=0 or z1~=0) and (x1~=0 or z1~=0) and (x1~=0 or y1~=0) then
                    if size~=3 then
                        cube(x1+x,y1+y,z1+z,s)
                    else
                        if clr then
                            scene.voxels:fill( 'name', 'empty')
                            scene.voxels:block((x1+x+50),(y1+y+50),(z1+z+50))
                        else
                            scene.voxels:fill("Table")
                            scene.voxels:block((x1+x+50),(y1+y+50),(z1+z+50))
                        end
                    end
                end
            end            
        end
    end
end   